#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// truchet quadtree distanceMod01.fsh   by   abje  
//https://www.shadertoy.com/view/MtcBDM
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//i made this shader because shane's shader looked so fancy
//https://www.shadertoy.com/view/4t3BW4
//
//Multi-Scale Truchet Patterns  - Christopher Carlson
//https://christophercarlson.com/portfolio/multi-scale-truchet-patterns/
//Linking paper containing more detail:
//http://archive.bridgesmathart.org/2018/bridges2018-39.pdf

//some macros
#define subs 0.4
#define limit 5.0
//#define grid

//some constant macros
#define HASHSCALE3 vec3(.6531, .5563, .7498)

//hash function in hash without sine by Dave_Hoskins
//https://www.shadertoy.com/view/4djSRW
//it seems to make a weird truchet pattern
float hash13(vec3 p3)
{
	p3  = fract(p3 * HASHSCALE3);
    p3 += dot(p3, p3.yzx + 19.19);
    return fract((p3.x + p3.y) * p3.z*15.3023+0.434);
}

float checktree(float i, vec2 r) {
    for (float j = 0.0; j < i; j++) {
        vec2 h = floor(r*exp2(j))*exp2(-j);
        float rand = hash13(vec3(h,int(j)));
        if (rand >= subs) {
            return j;
        }
    }
    return i;
}

float truchet(vec2 p, int type) {
    float len;
    if (type == 0)
    {
        p = p+step(p.x+p.y,0.0)-0.5;
        len = abs(length(p)-0.5)-0.1667;
    }
    else if (type == 1)
    {
        len = -length(abs(p)-0.5)+0.3333;
    }
    else if (type == 2)
    {
        vec2 dir;
        if (abs(p.x) > abs(p.y)) {
            dir = vec2(sign(p.x),0.0);
        } else {
            dir = vec2(0.0,sign(p.y));
        }
        len = abs(length(p-dir*0.5))-0.1667;
    }
    else if (type == 3)
    {
        vec2 dir;
        if (abs(p.x) > abs(p.y)) {
            dir = vec2(sign(p.x),0.0);
        } else {
            dir = vec2(0.0,sign(p.y));
        }
        len = min(abs(length(p-0.5)-0.5),abs(length(p-dir*0.5)))-0.1667;
    }
    else if (type == 4)
    {
        p = abs(p)-0.1667;

        len = -length(min(p,0.0))+max(min(p.x,p.y),0.0);
    }
    else if (type == 5)
    {
        p.y = abs(p.y);

        len = min(p.y,length(p-vec2(0,0.5)))-0.1667;
    }
    else if (type == 6)
    {
        p.x = abs(p.x);
        len = min(max(-p.y-0.1667,-length(p-0.5)+0.3333),length(p+vec2(0,0.5))-0.1667);      
    }
    return len;
}

float quadtruchet(vec2 p) {
    float len = 0.0;
    
    float j = checktree(limit, p);
    float i = j;
    
    //the position in the bottom left corner of the truchet cell
    vec2 fp = floor(p*exp2(i))*exp2(-i);

    //the local position on the truchet cell (always 0-1)
    vec2 lp = (p-fp)*exp2(i);
    
    float rand = fract(hash13(vec3(fp,-i))*10.0);
    vec2 q = lp-0.5;

    int celltype = int(rand*7.0);
    int rots = int(fract(rand*7.0)*4.0);

    for (int i = 0; i < rots; i++) {
        q = vec2(q.y,-q.x);
    }
    
    float l = truchet(q,celltype);
    
    len = l*exp2(-i)*(1.0-mod(i,2.0)*2.0);
    //len = l*exp2(-i);
    
    for (i = i; i <= limit; i++) {
        
        //the position in the bottom left corner of the truchet cell
        fp = floor(p*exp2(i))*exp2(-i);
		
        //the local position on the truchet cell (always 0-1)
        lp = (p-fp)*exp2(i);

        //check for the overlapping black dots
        vec2 p2 = p*exp2(i);
        vec2 fp2 = floor(p2-0.5);
        for(int x = -1; x <= 2; x++) {
            for(int y = -1; y <= 2; y++) {
                vec2 r = (fp2+vec2(x,y))*exp2(-i);
                //this branch doesn't do anything, but it skips the random() once
                if (r != fp)
                {
                    j = checktree(i, r);

                    if (i==j) {
                        float l = length(abs(p2-fp2-vec2(x,y)-0.5)-0.5)-0.3333;
                        float s = mod(i,2.0)*2.0-1.0;
                        len = min(l*exp2(-i),len*s)*s;
                    }
                }
            }
        }
	}
    return len;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{  
    // pixel coordinates (from -1 to 1)
    float scale = 1.0;
    vec2 uv = scale*(fragCoord*2.0-iResolution.xy)/iResolution.y;
    
    //"world space" coordinates, always moves up to the right.
    vec2 p = uv+iTime*0.1+vec2(-24,21);
    
    float len = quadtruchet(p);
    
    float a = exp2(checktree(limit,p));
    
    #ifdef grid
    vec2 lp = abs(fract(p*a)*2.0-1.0);
    float b = max(lp.x,lp.y);
    a /= iResolution.y*0.2;
    b = max(b-1.0+1.0*a,0.0)/a;
    #endif
    
    //distance field coloring by iq https://www.shadertoy.com/view/4lcBWn
    vec3 col = 1.0 - sign(len)*vec3(0.1,0.4,0.7);
	col *= min(1.0 - exp(-6.0*abs(len)),0.8);
	col *= 0.8 + 0.2*cos(200.0*abs(len));
	col = mix( col, vec3(1), 1.0-min(abs(len)*0.25*iResolution.y,1.0) );
    
    #ifdef grid
    col += b;
    #endif
    
    fragColor = vec4(col,1);
    
	//fragColor = vec4(vec3(sqrt(len*iResolution.y/scale*0.5)), 1);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

